define(['./_baseSortedIndex', './eq'], function(baseSortedIndex, eq) {

  'use strict';

  /**
   * This method is like `_.lastIndexOf` except that it performs a binary
   * search on a sorted `array`.
   *
   * @static
   * @memberOf _
   * @category Array
   * @param {Array} array The array to search.
   * @param {*} value The value to search for.
   * @returns {number} Returns the index of the matched value, else `-1`.
   * @example
   *
   * _.sortedLastIndexOf([1, 1, 2, 2], 2);
   * // => 3
   */
  function sortedLastIndexOf(array, value) {
    var length = array ? array.length : 0;
    if (length) {
      var index = baseSortedIndex(array, value, true) - 1;
      if (eq(array[index], value)) {
        return index;
      }
    }
    return -1;
  }

  return sortedLastIndexOf;
});
